--[[---------------------------------------------------------------------------
	Chocolatier Two Ledger: Inventory
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local layout = {}

local rowsVisible = 2

local ingredientsPerRow = 5
local ingredientsVisible = rowsVisible * ingredientsPerRow
local startIngredient = (gSim.inventoryTop - 1) * ingredientsPerRow + 1

local productsPerRow = 3
local productsVisible = rowsVisible * productsPerRow
local startProduct = (gSim.inventoryTop - 1) * productsPerRow + 1

local scrollDown = false

-------------------------------------------------------------------------------
-- Layout calculations

local dxIngredient = ui.sackWidth
local dxProduct = ui.crateWidth

local w = ingredientsPerRow * dxIngredient + productsPerRow * dxProduct
w = (ui.ledgerWidth - w - ui.scrollArrowW) / (ingredientsPerRow + productsPerRow)

dxIngredient = dxIngredient + w
local xIngredient = w/2

dxProduct = dxProduct + w
local xProduct = xIngredient + dxIngredient * ingredientsPerRow

local dy = ui.sackHeight-2
dy = dy + 10


if ui.sackHeight < ui.crateHeight then dy = ui.crateHeight-2 end
dy = dy + bsgFontHeight(invFont)
h = (ui.ledgerHeight - dy * rowsVisible) / (rowsVisible + 1)

local yTop = h/2
yTop = yTop + 10

-------------------------------------------------------------------------------
-- Lay out ingredients

local x = xIngredient
local y = yTop

local count = 0
local i = 0
local offsetX = (ui.sackWidth - ui.itemWidth) / 2
local offsetY = (ui.sackHeight - ui.itemHeight) / 2
local spaceX = (dxIngredient - ui.sackWidth) / 2

for item in LItem:OwnedIngredients() do
	i = i + 1
	if i >= startIngredient then
		count = count + 1
		if count > ingredientsVisible then
			scrollDown = true
			break
		end
		
		local inv = item.inventory
		local font = invFont
		if inv > 9999999 then font = invTinyFont
		elseif inv > 99999 then font = invSmallFont end
		if inv > 9999999 then inv = "9999999+" end
		
		table.insert(layout,
			Rollover { x=x,y=y, contents=item:RolloverTarget(),
				Bitmap { x=0,y=0, image="image/icon_sack" },
				Bitmap { x=offsetX,y=offsetY, image="item/"..item.name },
			})
		table.insert(layout, Text { x=x-spaceX,y=y+ui.sackHeight-2,w=dxIngredient,h=bsgFontHeight(font), flags=kVAlignTop+kHAlignCenter, label="#"..tostring(inv), font=font })

		x = x + dxIngredient
		if bsgMod(count, ingredientsPerRow) == 0 then
			x = xIngredient
			y = y + dy
		end
	end
end

-------------------------------------------------------------------------------
-- Lay out ingredients

x = xProduct
y = yTop

count = 0
i = 0
offsetX = (ui.crateWidth - ui.itemWidth) / 2
offsetY = (ui.crateHeight - ui.itemHeight) / 2
spaceX = (dxProduct - ui.crateWidth) / 2

for item in LItem:OwnedProducts() do
	i = i + 1
	if i >= startProduct then
		count = count + 1
		if count > productsVisible then
			scrollDown = true
			break
		end
		
		local inv = item.inventory
		local font = invFont
		if inv > 9999999 then font = invTinyFont
		elseif inv > 99999 then font = invSmallFont end
		if inv > 9999999 then inv = "9999999+" end
		
		table.insert(layout,
			Rollover { x=x,y=y, contents=item:RolloverTarget(),
				Bitmap { x=0,y=0, image="image/icon_crate", },
				Bitmap { x=offsetX,y=offsetY, image="item/"..item.name },
			})
		table.insert(layout, Text { x=x-spaceX,y=y+ui.crateHeight-2,w=dxProduct,h=bsgFontHeight(font), flags=kVAlignTop+kHAlignCenter, label="#"..tostring(inv), font=font })

		x = x + dxProduct
		if bsgMod(count, productsPerRow) == 0 then
			x = xProduct
			y = y + dy
		end
	end
end

-------------------------------------------------------------------------------
-- Scroll buttons

local function doScrollUp()
	gSim.inventoryTop = gSim.inventoryTop - rowsVisible
	UpdateLedgerContents("inventory")
end

if gSim.inventoryTop > rowsVisible then
	table.insert(layout,
		Button { x=ui.ledgerWidth-26,y=6, name="scroll_up",
				graphics={"control/scrollup_up", "control/scrollup_down", "control/scrollup_over"},
				command=doScrollUp, })
end

local function doScrollDown()
	gSim.inventoryTop = gSim.inventoryTop + rowsVisible
	UpdateLedgerContents("inventory")
end

if scrollDown then
	table.insert(layout,
		Button { x=ui.ledgerWidth-26,y=106, name="scroll_down",
				graphics={"control/scrolldown_up", "control/scrolldown_down", "control/scrolldown_over"},
				command=doScrollDown, })
end

-------------------------------------------------------------------------------

MakeDialog
{
	Bitmap { x=0,y=0, image="image/ledger_inventory" },
	Group(layout)
}
